(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12182,        273]*)
(*NotebookOutlinePosition[     12846,        296]*)
(*  CellTagsIndexPosition[     12802,        292]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(a = 
        Line[{{\(-4.25\), 1}, {\(-2.75\), 1}}];\)\), "\[IndentingNewLine]", 
    \(\(b = Line[{{\(-0.75\), 1}, {0.75, 1}}];\)\), "\[IndentingNewLine]", 
    \(\(c = Line[{{2.75, 1}, {4.25, 1}}];\)\), "\[IndentingNewLine]", 
    \(\(d = {Dashing[{0.02, 0.01}], 
          Line[{{\(-4.25\), 0}, {\(-4.25\), 
                1}}]};\)\), "\[IndentingNewLine]", 
    \(\(e = {Dashing[{0.02, 0.01}], 
          Line[{{\(-2.75\), 0}, {\(-2.75\), 
                1}}]};\)\), "\[IndentingNewLine]", 
    \(\(f = {Dashing[{0.02, 0.01}], 
          Line[{{\(-0.75\), 0}, {\(-0.75\), 
                1}}]};\)\), "\[IndentingNewLine]", 
    \(\(g = {Dashing[{0.02, 0.01}], 
          Line[{{0.75, 0}, {0.75, 1}}]};\)\), "\[IndentingNewLine]", 
    \(\(h = {Dashing[{0.02, 0.01}], 
          Line[{{2.75, 0}, {2.75, 1}}]};\)\), "\[IndentingNewLine]", 
    \(\(i = {Dashing[{0.02, 0.01}], 
          Line[{{4.25, 0}, {4.25, 1}}]};\)\), "\[IndentingNewLine]", 
    \(Show[
      Graphics[{Thickness[ .003], a, b, c, d, e, f, g, h, i, 
          Line[{{1.75, \(- .05\)}, {1.75,  .05}}], 
          Line[{{\(-1.75\), \(- .05\)}, {\(-1.75\),  .05}}], 
          Line[{{3.5, \(- .05\)}, {3.5,  .05}}], 
          Line[{{\(-3.5\), \(- .05\)}, {\(-3.5\),  .05}}], 
          Text["\<0\>", {0.17, \(- .15\)}], 
          Text["\<D2\>", {0.75, \(- .15\)}], 
          Text["\<T2\>", {1.75, \(- .15\)}], 
          Text["\<T3\>", {3.5, \(- .15\)}], 
          Text["\<D2n\>", {\(-0.75\), \(- .15\)}], 
          Text["\<T2n\>", {\(-1.75\), \(- .15\)}], 
          Text["\<T3n\>", {\(-3.5\), \(- .15\)}], 
          Text["\<A\>", {0.19, 1.07}]}], Axes \[Rule] True, 
      Ticks \[Rule] None, PlotRange \[Rule] {{\(-5\), 5}, {\(- .2\), 1.2}}, 
      AspectRatio \[Rule]  .3]\)}], "Input"],

Cell[BoxData[
    \(Display["\<impulsos.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[{
    \(\(rec[a_:  0, b_:  1]\)[
        t_] := \(\(UnitStep[t + b/2 - a]\)\(-\)\(UnitStep[
          t - b/2 - a]\)\(\ \)\( (*\ 
          la\ funci\[OAcute]n\ caracter\[IAcute]stica\ del\ intervalo\ \
centrado\ en\ a\ de\ longitud\ b\ *) \)\(\ \)\)\), "\[IndentingNewLine]", 
    \(\(tri[a_:  0, b_:  1]\)[
        t_] := \((1 - Abs[2 \((t - a)\)/b])\)*\(rec[a, b]\)\ [
          t]\), "\[IndentingNewLine]", 
    \( (*\ 
      la\ funci\[OAcute]n\ tri\[AAcute]ngulo\ centrada\ en\ a\ de\ base\ [
          a - b/2, a + b/2]\ *) \)}], "Input"],

Cell[BoxData[
    \(f[x_] := \(rec[0, 1.5]\)[x] + \(rec[0, 1.5]\)[
          x + 3.5] + \(rec[0, 1.5]\)[x - 3.5]\)], "Input"],

Cell[BoxData[
    \(Plot[f[x], {x, \(-5\), 5}, Axes \[Rule] True, Ticks \[Rule] None, 
      PlotRange \[Rule] {{\(-5\), 5}, {\(- .2\), 1.2}}, 
      AspectRatio \[Rule]  .3]\)], "Input"],

Cell[BoxData[{
    \(g[x_] := 1 /; Abs[x] <  .5\), "\[IndentingNewLine]", 
    \(g[x_] := 0 /; Abs[x] \[GreaterEqual]  .5\)}], "Input"],

Cell[BoxData[
    \(G[x_] := 
      g[x/1.5] + g[\((x + 3.5)\)/1.5] + g[\((x - 3.5)\)/1.5]\)], "Input"],

Cell[BoxData[
    \(Plot[G[x], {x, \(-5\), 5}, Axes \[Rule] True, Ticks \[Rule] None, 
      PlotRange \[Rule] {{\(-5\), 5}, {\(- .2\), 1.2}}, 
      AspectRatio \[Rule]  .3]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`Arrow`\)], "Input"],

Cell[BoxData[{
    \(\(f1 = 
        Arrow[{\(-4.25\), 0}, {\(-4.25\), 1}];\)\), "\[IndentingNewLine]", 
    \(\(f2 = 
        Arrow[{\(-2.75\), 
            0}, {\(-2.75\), \(-1\)}];\)\), "\[IndentingNewLine]", 
    \(\(f3 = 
        Arrow[{\(-0.75\), 0}, {\(-0.75\), 1}];\)\), "\[IndentingNewLine]", 
    \(\(f4 = Arrow[{0.75, 0}, {0.75, \(-1\)}];\)\), "\[IndentingNewLine]", 
    \(\(f5 = Arrow[{2.75, 0}, {2.75, 1}];\)\), "\[IndentingNewLine]", 
    \(\(f6 = Arrow[{4.25, 0}, {4.25, \(-1\)}];\)\), "\[IndentingNewLine]", 
    \(Show[
      Graphics[{Thickness[ .003], f1, f2, f3, f4, f5, f6, 
          Line[{{1.75, \(- .05\)}, {1.75,  .05}}], 
          Line[{{\(-1.75\), \(- .05\)}, {\(-1.75\),  .05}}], 
          Line[{{3.5, \(- .05\)}, {3.5,  .05}}], 
          Line[{{\(-3.5\), \(- .05\)}, {\(-3.5\),  .05}}], 
          Text["\<0\>", {0.17, \(- .15\)}], Text["\<D2\>", {0.75,  .15}], 
          Text["\<T2\>", {1.75, \(- .15\)}], 
          Text["\<T3\>", {3.5, \(- .15\)}], 
          Text["\<D2n\>", {\(-0.75\), \(- .15\)}], 
          Text["\<T2n\>", {\(-1.75\), \(- .15\)}], 
          Text["\<T3n\>", {\(-3.5\), \(- .15\)}], 
          Text["\<A\>", {\(-1.5\), 1.17}], Text["\<B\>", {0.6, \(-1.17\)}]}], 
      Axes \[Rule] True, Ticks \[Rule] None, 
      PlotRange \[Rule] {{\(-5\), 5}, {\(-1.3\), 1.3}}, 
      AspectRatio \[Rule]  .7]\)}], "Input"],

Cell[BoxData[
    \(Display["\<flechas.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[{
    \(\(l = 
        Line[{{\(-28\), 0}, {\(-23\), 5}, {\(-17\), 5}, {\(-12\), 
              0}, {\(-8\), 0}, {\(-3\), 5}, {3, 5}, {8, 0}, {12, 0}, {17, 
              5}, {23, 5}, {28, 0}}];\)\), "\[IndentingNewLine]", 
    \(Show[
      Graphics[{{Dashing[{0.02, 0.01}], 
            Line[{{3, 0}, {3, 5}}]}, {Dashing[{0.02, 0.01}], 
            Line[{{\(-3\), 0}, {\(-3\), 5}}]}, Thickness[ .003], l, 
          Line[{{20, \(- .15\)}, {20,  .15}}], 
          Line[{{\(-20\), \(- .15\)}, {\(-20\),  .15}}], 
          Line[{{10, \(- .15\)}, {10,  .15}}], 
          Line[{{\(-10\), \(- .15\)}, {\(-10\),  .15}}], 
          Line[{{8, \(- .15\)}, {8,  .15}}], 
          Line[{{\(-8\), \(- .15\)}, {\(-8\),  .15}}], 
          Line[{{3, \(- .15\)}, {3,  .15}}], 
          Line[{{\(-3\), \(- .15\)}, {\(-3\),  .15}}], 
          Text["\<0\>", {0.9, \(- .4\)}], Text["\<D1\>", {3.2, \(- .4\)}], 
          Text["\<D2\>", {8, \(- .4\)}], Text["\<T2\>", {10,  .8}], 
          Text["\<T\>", {20.6, \(- .4\)}], 
          Text["\<-D1\>", {\(-3\), \(- .4\)}], 
          Text["\<-D2\>", {\(-8.4\), \(- .4\)}], 
          Text["\<-T2\>", {\(-10\),  .8}], 
          Text["\<-T\>", {\(-20\), \(- .4\)}], 
          Text["\<A\>", {\(-0.9\), 5.4}]}], Axes \[Rule] True, 
      Ticks \[Rule] None, PlotRange \[Rule] {{\(-30\), 30}, {\(- .7\), 6}}, 
      AspectRatio \[Rule]  .4]\)}], "Input"],

Cell[BoxData[
    \(Display["\<trapecios.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Line[{{\(-28\), 0}, {\(-23\), 5}, {\(-17\), 5}, {\(-12\), 0}, {\(-8\), 
          0}, {\(-3\), 5}, {3, 5}, {8, 0}, {12, 0}, {17, 5}, {23, 5}, {28, 
          0}}]\)], "Input"],

Cell[BoxData[{
    \(\(l2 = 
        Line[{{\(-28\), 0}, {\(-28\), 5}, {\(-23\), 5}, {\(-23\), 
              0}, {\(-17\), 
              0}, {\(-17\), \(-5\)}, {\(-12\), \(-5\)}, {\(-12\), 
              0}, {\(-8\), 0}, {\(-8\), 5}, {\(-3\), 5}, {\(-3\), 0}, {0, 
              0}, {3, 0}, {3, \(-5\)}, {8, \(-5\)}, {8, 0}, {12, 0}, {12, 
              5}, {17, 5}, {17, 0}, {23, 0}, {23, \(-5\)}, {28, \(-5\)}, {28, 
              0}}];\)\), "\[IndentingNewLine]", 
    \(Show[
      Graphics[{Thickness[ .003], l2, Line[{{20, \(- .15\)}, {20,  .15}}], 
          Line[{{\(-20\), \(- .15\)}, {\(-20\),  .15}}], 
          Line[{{10, \(- .15\)}, {10,  .15}}], 
          Line[{{\(- .35\), 5}, { .35, 5}}], 
          Line[{{\(- .35\), \(-5\)}, { .35, \(-5\)}}], 
          Line[{{\(-10\), \(- .15\)}, {\(-10\),  .15}}], 
          Line[{{8, \(- .15\)}, {8,  .15}}], 
          Line[{{\(-8\), \(- .15\)}, {\(-8\),  .15}}], 
          Line[{{3, \(- .15\)}, {3,  .15}}], 
          Line[{{\(-3\), \(- .15\)}, {\(-3\),  .15}}], 
          Text["\<0\>", {0.9, \(- .4\)}], Text["\<D1\>", {3.2,  .4}], 
          Text["\<D2\>", {7.7,  .4}], Text["\<T2\>", {10,  .8}], 
          Text["\<T\>", {20.8, \(- .6\)}], 
          Text["\<-D1\>", {\(-3\), \(- .6\)}], 
          Text["\<-D2\>", {\(-8.4\), \(- .6\)}], 
          Text["\<-T2\>", {\(-10.4\),  .7}], 
          Text["\<-T\>", {\(-20.4\), \(- .6\)}], Text["\<A\>", {2.9, 5.4}], 
          Text["\<B\>", {\(-4.9\), \(-5.4\)}]}], Axes \[Rule] True, 
      Ticks \[Rule] None, PlotRange \[Rule] {{\(-30\), 30}, {\(-6\), 6}}, 
      AspectRatio \[Rule]  .6]\)}], "Input"],

Cell[BoxData[
    \(Display["\<dertrapecios.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[{
    \(\(A1 = Arrow[{\(-28\), 0}, {\(-28\), 5}];\)\), "\[IndentingNewLine]", 
    \(\(A2 = 
        Arrow[{\(-23\), 0}, {\(-23\), \(-5\)}];\)\), "\[IndentingNewLine]", 
    \(\(A3 = 
        Arrow[{\(-17\), 0}, {\(-17\), \(-5\)}];\)\), "\[IndentingNewLine]", 
    \(\(A4 = Arrow[{\(-12\), 0}, {\(-12\), 5}];\)\), "\[IndentingNewLine]", 
    \(\(A5 = Arrow[{\(-8\), 0}, {\(-8\), 5}];\)\), "\[IndentingNewLine]", 
    \(\(A6 = 
        Arrow[{\(-3\), 0}, {\(-3\), \(-5\)}];\)\), "\[IndentingNewLine]", 
    \(\(A7 = Arrow[{3, 0}, {3, \(-5\)}];\)\), "\[IndentingNewLine]", 
    \(\(A8 = Arrow[{8, 0}, {8, 5}];\)\), "\[IndentingNewLine]", 
    \(\(A9 = Arrow[{12, 0}, {12, 5}];\)\), "\[IndentingNewLine]", 
    \(\(A10 = Arrow[{17, 0}, {17, \(-5\)}];\)\), "\[IndentingNewLine]", 
    \(\(A11 = Arrow[{23, 0}, {23, \(-5\)}];\)\), "\[IndentingNewLine]", 
    \(\(A12 = Arrow[{28, 0}, {28, 5}];\)\), "\[IndentingNewLine]", 
    \(Show[
      Graphics[{Thickness[ .003], A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, 
          A11, A12, Line[{{20, \(- .15\)}, {20,  .15}}], 
          Line[{{\(-20\), \(- .15\)}, {\(-20\),  .15}}], 
          Line[{{10, \(- .15\)}, {10,  .15}}], 
          Line[{{\(- .35\), 5}, { .35, 5}}], 
          Line[{{\(- .35\), \(-5\)}, { .35, \(-5\)}}], 
          Line[{{\(-10\), \(- .15\)}, {\(-10\),  .15}}], 
          Line[{{8, \(- .15\)}, {8,  .15}}], 
          Line[{{\(-8\), \(- .15\)}, {\(-8\),  .15}}], 
          Line[{{3, \(- .15\)}, {3,  .15}}], 
          Line[{{\(-3\), \(- .15\)}, {\(-3\),  .15}}], 
          Text["\<0\>", {0.9, \(- .4\)}], Text["\<D1\>", {3.2,  .5}], 
          Text["\<D2\>", {7.7, \(- .6\)}], Text["\<T2\>", {10,  .7}], 
          Text["\<T-b\>", {12.8, \(- .6\)}], Text["\<T-a\>", {17,  .5}], 
          Text["\<T\>", {20.8, \(- .6\)}], Text["\<T+a\>", {23,  .5}], 
          Text["\<T+b\>", {28, \(- .5\)}], Text["\<-D1\>", {\(-3\),  .5}], 
          Text["\<-D2\>", {\(-8.4\), \(- .6\)}], 
          Text["\<-T2\>", {\(-10.4\),  .7}], 
          Text["\<-T\>", {\(-20.4\), \(- .6\)}], Text["\<A\>", {2.9, 5.4}], 
          Text["\<B\>", {\(-1.9\), \(-5.8\)}]}], Axes \[Rule] True, 
      Ticks \[Rule] None, PlotRange \[Rule] {{\(-30\), 30}, {\(-6\), 6}}, 
      AspectRatio \[Rule]  .6]\)}], "Input"],

Cell[BoxData[
    \(Display["\<derdostrapecios.eps\>", %, "\<EPS\>"]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 788}},
WindowSize->{1144, 753},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1792, 35, 406, "Input"],
Cell[3549, 88, 74, 1, 42, "Input"],
Cell[3626, 91, 558, 11, 120, "Input"],
Cell[4187, 104, 125, 2, 42, "Input"],
Cell[4315, 108, 187, 3, 68, "Input"],
Cell[4505, 113, 135, 2, 68, "Input"],
Cell[4643, 117, 103, 2, 42, "Input"],
Cell[4749, 121, 187, 3, 68, "Input"],
Cell[4939, 126, 51, 1, 42, "Input"],
Cell[4993, 129, 1368, 26, 354, "Input"],
Cell[6364, 157, 73, 1, 42, "Input"],
Cell[6440, 160, 1401, 26, 328, "Input"],
Cell[7844, 188, 75, 1, 42, "Input"],
Cell[7922, 191, 195, 3, 68, "Input"],
Cell[8120, 196, 1618, 29, 354, "Input"],
Cell[9741, 227, 78, 1, 42, "Input"],
Cell[9822, 230, 2272, 38, 614, "Input"],
Cell[12097, 270, 81, 1, 42, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

